// VisaAttributeMetadata.h : data types, etc., for VISA attribute table
//


typedef enum
{
	VisaType_Unknown,
	VisaType_Bool,
	VisaType_Int08,
	VisaType_UInt08,
	VisaType_Int16,
	VisaType_UInt16,
	VisaType_Int32,
	VisaType_UInt32,
	VisaType_Str,
}
VisaAttributeDataType;

#define VISA_ATTRIB_F_GLOBAL		(0x0001)
#define VISA_ATTRIB_F_READONLY		(0x0002)
#define VISA_ATTRIB_F_GLOB_RO		(VISA_ATTRIB_F_GLOBAL | VISA_ATTRIB_F_READONLY)
#define VISA_ATTRIB_F_TRI_STATE		(0x0004)
#define VISA_ATTRIB_F_SHOW_IN_HEX	(0x0010)


typedef struct
{
	LPCTSTR m_pszSymbolicName;
	ULONG m_idAttrib;
	VisaAttributeDataType m_fDataType;
	USHORT m_fFlags;
}
VisaAttribMetadataTableEntry;

typedef VisaAttribMetadataTableEntry* pAttribMetadataTableEntry;

typedef VisaAttribMetadataTableEntry* pAttribMetadataTbl;

extern VisaAttribMetadataTableEntry g_tableVisaAttribMetadata[];


pAttribMetadataTableEntry
FindAttributeTableEntry(
	LPCTSTR pszAttrName
);

char*
VisaAttributeDataType2String(
	VisaAttributeDataType fAttrType
);
